/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigMapVolumeSourceBuilder
extends ConfigMapVolumeSourceFluentImpl<ConfigMapVolumeSourceBuilder>
implements VisitableBuilder<ConfigMapVolumeSource, ConfigMapVolumeSourceBuilder> {
    ConfigMapVolumeSourceFluent<?> fluent;

    public ConfigMapVolumeSourceBuilder() {
        this(new ConfigMapVolumeSource());
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent) {
        this(fluent, new ConfigMapVolumeSource());
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent, ConfigMapVolumeSource instance) {
        this.fluent = fluent;
        fluent.withItems(instance.getItems());
        fluent.withName(instance.getName());
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSource instance) {
        this.fluent = this;
        this.withItems(instance.getItems());
        this.withName(instance.getName());
    }

    public ConfigMapVolumeSource build() {
        ConfigMapVolumeSource buildable = new ConfigMapVolumeSource(this.fluent.getItems(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapVolumeSourceBuilder that = (ConfigMapVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

