/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableFlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.FlockerVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class FlockerVolumeSourceBuilder
extends FlockerVolumeSourceFluentImpl<FlockerVolumeSourceBuilder>
implements VisitableBuilder<FlockerVolumeSource, FlockerVolumeSourceBuilder> {
    FlockerVolumeSourceFluent<?> fluent;

    public FlockerVolumeSourceBuilder() {
        this(new FlockerVolumeSource());
    }

    public FlockerVolumeSourceBuilder(FlockerVolumeSourceFluent<?> fluent) {
        this(fluent, new FlockerVolumeSource());
    }

    public FlockerVolumeSourceBuilder(FlockerVolumeSourceFluent<?> fluent, FlockerVolumeSource instance) {
        this.fluent = fluent;
        fluent.withDatasetName(instance.getDatasetName());
    }

    public FlockerVolumeSourceBuilder(FlockerVolumeSource instance) {
        this.fluent = this;
        this.withDatasetName(instance.getDatasetName());
    }

    public EditableFlockerVolumeSource build() {
        EditableFlockerVolumeSource buildable = new EditableFlockerVolumeSource(this.fluent.getDatasetName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlockerVolumeSourceBuilder that = (FlockerVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

