/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeleteOptionsFluent;
import io.fabric8.kubernetes.api.model.DeleteOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.EditableDeleteOptions;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeleteOptionsBuilder
extends DeleteOptionsFluentImpl<DeleteOptionsBuilder>
implements VisitableBuilder<DeleteOptions, DeleteOptionsBuilder> {
    DeleteOptionsFluent<?> fluent;

    public DeleteOptionsBuilder() {
        this(new DeleteOptions());
    }

    public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent) {
        this(fluent, new DeleteOptions());
    }

    public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent, DeleteOptions instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        fluent.withKind(instance.getKind());
        fluent.withPreconditions(instance.getPreconditions());
    }

    public DeleteOptionsBuilder(DeleteOptions instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withPreconditions(instance.getPreconditions());
    }

    public EditableDeleteOptions build() {
        EditableDeleteOptions buildable = new EditableDeleteOptions(this.fluent.getApiVersion(), this.fluent.getGracePeriodSeconds(), this.fluent.getKind(), this.fluent.getPreconditions());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteOptionsBuilder that = (DeleteOptionsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

