package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentConfigStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentConfigStatusAssert<S extends AbstractDeploymentConfigStatusAssert<S, A>, A extends DeploymentConfigStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentConfigStatusAssert}</code> to make assertions on actual DeploymentConfigStatus.
   * @param actual the DeploymentConfigStatus we want to make assertions on.
   */
  protected AbstractDeploymentConfigStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property details so that assertions can be done on it
   */
  public DeploymentDetailsAssert details()  {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeploymentDetailsAssert) assertThat(actual.getDetails()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "details"));
  }


  /**
   * Verifies that the actual DeploymentConfigStatus's latestVersion is equal to the given one.
   * @param latestVersion the given latestVersion to compare the actual DeploymentConfigStatus's latestVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's latestVersion is not equal to the given one.
   */
  public S hasLatestVersion(Integer latestVersion) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting latestVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLatestVersion = actual.getLatestVersion();
    if (!Objects.areEqual(actualLatestVersion, latestVersion)) {
      failWithMessage(assertjErrorMessage, actual, latestVersion, actualLatestVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
