/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableRollingUpdateDeployment;
import io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment;
import io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RollingUpdateDeploymentBuilder
extends RollingUpdateDeploymentFluentImpl<RollingUpdateDeploymentBuilder>
implements VisitableBuilder<RollingUpdateDeployment, RollingUpdateDeploymentBuilder> {
    RollingUpdateDeploymentFluent<?> fluent;

    public RollingUpdateDeploymentBuilder() {
        this(new RollingUpdateDeployment());
    }

    public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent) {
        this(fluent, new RollingUpdateDeployment());
    }

    public RollingUpdateDeploymentBuilder(RollingUpdateDeploymentFluent<?> fluent, RollingUpdateDeployment instance) {
        this.fluent = fluent;
        fluent.withMaxSurge(instance.getMaxSurge());
        fluent.withMaxUnavailable(instance.getMaxUnavailable());
    }

    public RollingUpdateDeploymentBuilder(RollingUpdateDeployment instance) {
        this.fluent = this;
        this.withMaxSurge(instance.getMaxSurge());
        this.withMaxUnavailable(instance.getMaxUnavailable());
    }

    public EditableRollingUpdateDeployment build() {
        EditableRollingUpdateDeployment buildable = new EditableRollingUpdateDeployment(this.fluent.getMaxSurge(), this.fluent.getMaxUnavailable());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RollingUpdateDeploymentBuilder that = (RollingUpdateDeploymentBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

