/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableImageChangeTrigger;
import io.fabric8.openshift.api.model.ImageChangeTrigger;
import io.fabric8.openshift.api.model.ImageChangeTriggerFluent;
import io.fabric8.openshift.api.model.ImageChangeTriggerFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageChangeTriggerBuilder
extends ImageChangeTriggerFluentImpl<ImageChangeTriggerBuilder>
implements VisitableBuilder<ImageChangeTrigger, ImageChangeTriggerBuilder> {
    ImageChangeTriggerFluent<?> fluent;

    public ImageChangeTriggerBuilder() {
        this(new ImageChangeTrigger());
    }

    public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent) {
        this(fluent, new ImageChangeTrigger());
    }

    public ImageChangeTriggerBuilder(ImageChangeTriggerFluent<?> fluent, ImageChangeTrigger instance) {
        this.fluent = fluent;
        fluent.withFrom(instance.getFrom());
        fluent.withLastTriggeredImageID(instance.getLastTriggeredImageID());
    }

    public ImageChangeTriggerBuilder(ImageChangeTrigger instance) {
        this.fluent = this;
        this.withFrom(instance.getFrom());
        this.withLastTriggeredImageID(instance.getLastTriggeredImageID());
    }

    public EditableImageChangeTrigger build() {
        EditableImageChangeTrigger buildable = new EditableImageChangeTrigger(this.fluent.getFrom(), this.fluent.getLastTriggeredImageID());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageChangeTriggerBuilder that = (ImageChangeTriggerBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

