package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildConfigSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildConfigSpecAssert<S extends AbstractBuildConfigSpecAssert<S, A>, A extends BuildConfigSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildConfigSpecAssert}</code> to make assertions on actual BuildConfigSpec.
   * @param actual the BuildConfigSpec we want to make assertions on.
   */
  protected AbstractBuildConfigSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual BuildConfigSpec's completionDeadlineSeconds is equal to the given one.
   * @param completionDeadlineSeconds the given completionDeadlineSeconds to compare the actual BuildConfigSpec's completionDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigSpec's completionDeadlineSeconds is not equal to the given one.
   */
  public S hasCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting completionDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualCompletionDeadlineSeconds = actual.getCompletionDeadlineSeconds();
    if (!Objects.areEqual(actualCompletionDeadlineSeconds, completionDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, completionDeadlineSeconds, actualCompletionDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property output so that assertions can be done on it
   */
  public BuildOutputAssert output()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BuildOutputAssert) assertThat(actual.getOutput()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "output"));
  }


  /**
   * Navigates to the property postCommit so that assertions can be done on it
   */
  public BuildPostCommitSpecAssert postCommit()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BuildPostCommitSpecAssert) assertThat(actual.getPostCommit()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "postCommit"));
  }


  /**
   * Navigates to the property resources so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ResourceRequirementsAssert resources()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ResourceRequirementsAssert) assertThat(actual.getResources()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resources"));
  }


  /**
   * Navigates to the property revision so that assertions can be done on it
   */
  public SourceRevisionAssert revision()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceRevisionAssert) assertThat(actual.getRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "revision"));
  }


  /**
   * Navigates to the property serviceAccount so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert serviceAccount()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"));
  }


  /**
   * Navigates to the property source so that assertions can be done on it
   */
  public BuildSourceAssert source()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BuildSourceAssert) assertThat(actual.getSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "source"));
  }


  /**
   * Navigates to the property strategy so that assertions can be done on it
   */
  public BuildStrategyAssert strategy()  {
    // check that actual BuildConfigSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BuildStrategyAssert) assertThat(actual.getStrategy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "strategy"));
  }


  /**
   * Navigates to the property triggers so that assertions can be done on it
   */
  public NavigationListAssert<BuildTriggerPolicy, BuildTriggerPolicyAssert> triggers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<BuildTriggerPolicy, BuildTriggerPolicyAssert> assertFactory = new AssertFactory<BuildTriggerPolicy, BuildTriggerPolicyAssert>() {
      public BuildTriggerPolicyAssert createAssert(BuildTriggerPolicy t) {
        return (BuildTriggerPolicyAssert) assertThat(t);
      }
    };
    NavigationListAssert<BuildTriggerPolicy, BuildTriggerPolicyAssert> answer = new NavigationListAssert<BuildTriggerPolicy, BuildTriggerPolicyAssert>(actual.getTriggers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggers"));
    return answer;
  }


}
