package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RouteIngress} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteIngressAssert<S extends AbstractRouteIngressAssert<S, A>, A extends RouteIngress> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteIngressAssert}</code> to make assertions on actual RouteIngress.
   * @param actual the RouteIngress we want to make assertions on.
   */
  protected AbstractRouteIngressAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RouteIngress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<RouteIngressCondition, RouteIngressConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<RouteIngressCondition, RouteIngressConditionAssert> assertFactory = new AssertFactory<RouteIngressCondition, RouteIngressConditionAssert>() {
      public RouteIngressConditionAssert createAssert(RouteIngressCondition t) {
        return (RouteIngressConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<RouteIngressCondition, RouteIngressConditionAssert> answer = new NavigationListAssert<RouteIngressCondition, RouteIngressConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property host so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert host()  {
    // check that actual RouteIngress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getHost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "host"));
  }


  /**
   * Navigates to the property routerName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert routerName()  {
    // check that actual RouteIngress we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getRouterName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "routerName"));
  }


}
