package io.fabric8.kubernetes.api.model.extensions;


/**
 * {@link APIVersion} specific assertions - Generated by CustomAssertionGenerator.
 *
 * Although this class is not final to allow Soft assertions proxy, if you wish to extend it, 
 * extend {@link AbstractAPIVersionAssert} instead.
 */
public class APIVersionAssert extends AbstractAPIVersionAssert<APIVersionAssert, APIVersion> {

  /**
   * Creates a new <code>{@link APIVersionAssert}</code> to make assertions on actual APIVersion.
   * @param actual the APIVersion we want to make assertions on.
   */
  public APIVersionAssert(APIVersion actual) {
    super(actual, APIVersionAssert.class);
  }

  /**
   * An entry point for APIVersionAssert to follow AssertJ standard <code>assertThat()</code> statements.<br>
   * With a static import, one can write directly: <code>assertThat(myAPIVersion)</code> and get specific assertion with code completion.
   * @param actual the APIVersion we want to make assertions on.
   * @return a new <code>{@link APIVersionAssert}</code>
   */
  public static APIVersionAssert assertThat(APIVersion actual) {
    return new APIVersionAssert(actual);
  }
}
