package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SecurityContext} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecurityContextAssert<S extends AbstractSecurityContextAssert<S, A>, A extends SecurityContext> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecurityContextAssert}</code> to make assertions on actual SecurityContext.
   * @param actual the SecurityContext we want to make assertions on.
   */
  protected AbstractSecurityContextAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property capabilities so that assertions can be done on it
   */
  public CapabilitiesAssert capabilities()  {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CapabilitiesAssert) assertThat(actual.getCapabilities()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capabilities"));
  }


  /**
   * Navigates to the property privileged so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert privileged()  {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getPrivileged()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "privileged"));
  }


  /**
   * Navigates to the property readOnlyRootFilesystem so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnlyRootFilesystem()  {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnlyRootFilesystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnlyRootFilesystem"));
  }


  /**
   * Navigates to the property runAsNonRoot so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert runAsNonRoot()  {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getRunAsNonRoot()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsNonRoot"));
  }


  /**
   * Verifies that the actual SecurityContext's runAsUser is equal to the given one.
   * @param runAsUser the given runAsUser to compare the actual SecurityContext's runAsUser to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SecurityContext's runAsUser is not equal to the given one.
   */
  public S hasRunAsUser(Long runAsUser) {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting runAsUser of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualRunAsUser = actual.getRunAsUser();
    if (!Objects.areEqual(actualRunAsUser, runAsUser)) {
      failWithMessage(assertjErrorMessage, actual, runAsUser, actualRunAsUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property seLinuxOptions so that assertions can be done on it
   */
  public SELinuxOptionsAssert seLinuxOptions()  {
    // check that actual SecurityContext we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SELinuxOptionsAssert) assertThat(actual.getSeLinuxOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinuxOptions"));
  }


}
