package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link KubernetesList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubernetesListAssert<S extends AbstractKubernetesListAssert<S, A>, A extends KubernetesList> extends AbstractBaseKubernetesListAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubernetesListAssert}</code> to make assertions on actual KubernetesList.
   * @param actual the KubernetesList we want to make assertions on.
   */
  protected AbstractKubernetesListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property items so that assertions can be done on it
   */
  public NavigationListAssert<HasMetadata, HasMetadataAssert> items()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<HasMetadata, HasMetadataAssert> assertFactory = new AssertFactory<HasMetadata, HasMetadataAssert>() {
      public HasMetadataAssert createAssert(HasMetadata t) {
        return (HasMetadataAssert) assertThat(t);
      }
    };
    NavigationListAssert<HasMetadata, HasMetadataAssert> answer = new NavigationListAssert<HasMetadata, HasMetadataAssert>(actual.getItems(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "items"));
    return answer;
  }


}
