/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressTLS;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractIngressSpecAssert<S extends AbstractIngressSpecAssert<S, A>, A extends IngressSpec>
extends AbstractAssert<S, A> {
    protected AbstractIngressSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((IngressSpec)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasBackend(IngressBackend backend) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting backend of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        IngressBackend actualBackend = ((IngressSpec)this.actual).getBackend();
        if (!Objects.areEqual((Object)actualBackend, (Object)backend)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, backend, actualBackend});
        }
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasRules(IngressRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            this.failWithMessage("Expecting rules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((IngressSpec)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasOnlyRules(IngressRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            this.failWithMessage("Expecting rules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((IngressSpec)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S doesNotHaveRules(IngressRule ... rules) {
        this.isNotNull();
        if (rules == null) {
            this.failWithMessage("Expecting rules parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((IngressSpec)this.actual).getRules(), (Object[])rules);
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasNoRules() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have rules but had :\n  <%s>";
        if (((IngressSpec)this.actual).getRules().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((IngressSpec)this.actual).getRules()});
        }
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasTls(IngressTLS ... tls) {
        this.isNotNull();
        if (tls == null) {
            this.failWithMessage("Expecting tls parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((IngressSpec)this.actual).getTls(), (Object[])tls);
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasOnlyTls(IngressTLS ... tls) {
        this.isNotNull();
        if (tls == null) {
            this.failWithMessage("Expecting tls parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((IngressSpec)this.actual).getTls(), (Object[])tls);
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S doesNotHaveTls(IngressTLS ... tls) {
        this.isNotNull();
        if (tls == null) {
            this.failWithMessage("Expecting tls parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((IngressSpec)this.actual).getTls(), (Object[])tls);
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }

    public S hasNoTls() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tls but had :\n  <%s>";
        if (((IngressSpec)this.actual).getTls().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((IngressSpec)this.actual).getTls()});
        }
        return (S)((Object)((AbstractIngressSpecAssert)this.myself));
    }
}

