package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TagImportPolicy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagImportPolicyAssert<S extends AbstractTagImportPolicyAssert<S, A>, A extends TagImportPolicy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagImportPolicyAssert}</code> to make assertions on actual TagImportPolicy.
   * @param actual the TagImportPolicy we want to make assertions on.
   */
  protected AbstractTagImportPolicyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TagImportPolicy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TagImportPolicy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagImportPolicy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TagImportPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagImportPolicy's insecure is equal to the given one.
   * @param insecure the given insecure to compare the actual TagImportPolicy's insecure to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagImportPolicy's insecure is not equal to the given one.
   */
  public S hasInsecure(Boolean insecure) {
    // check that actual TagImportPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting insecure of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualInsecure = actual.getInsecure();
    if (!Objects.areEqual(actualInsecure, insecure)) {
      failWithMessage(assertjErrorMessage, actual, insecure, actualInsecure);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagImportPolicy's scheduled is equal to the given one.
   * @param scheduled the given scheduled to compare the actual TagImportPolicy's scheduled to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagImportPolicy's scheduled is not equal to the given one.
   */
  public S hasScheduled(Boolean scheduled) {
    // check that actual TagImportPolicy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scheduled of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualScheduled = actual.getScheduled();
    if (!Objects.areEqual(actualScheduled, scheduled)) {
      failWithMessage(assertjErrorMessage, actual, scheduled, actualScheduled);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
