package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageSourceFluentImplAssert<S extends AbstractImageSourceFluentImplAssert<S, A>, A extends ImageSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageSourceFluentImplAssert}</code> to make assertions on actual ImageSourceFluentImpl.
   * @param actual the ImageSourceFluentImpl we want to make assertions on.
   */
  protected AbstractImageSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourceFluentImpl's from is equal to the given one.
   * @param from the given from to compare the actual ImageSourceFluentImpl's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageSourceFluentImpl's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourceFluentImpl's paths contains the given ImageSourcePath elements.
   * @param paths the given elements that should be contained in actual ImageSourceFluentImpl's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageSourceFluentImpl's paths does not contain all given ImageSourcePath elements.
   */
  public S hasPaths(ImageSourcePath... paths) {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ImageSourcePath varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourceFluentImpl's paths contains <b>only<b> the given ImageSourcePath elements and nothing else in whatever order.
   * @param paths the given elements that should be contained in actual ImageSourceFluentImpl's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageSourceFluentImpl's paths does not contain all given ImageSourcePath elements.
   */
  public S hasOnlyPaths(ImageSourcePath... paths) {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ImageSourcePath varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourceFluentImpl's paths does not contain the given ImageSourcePath elements.
   *
   * @param paths the given elements that should not be in actual ImageSourceFluentImpl's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageSourceFluentImpl's paths contains any given ImageSourcePath elements.
   */
  public S doesNotHavePaths(ImageSourcePath... paths) {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ImageSourcePath varargs is not null.
    if (paths == null) failWithMessage("Expecting paths parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourceFluentImpl has no paths.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageSourceFluentImpl's paths is not empty.
   */
  public S hasNoPaths() {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have paths but had :\n  <%s>";
    
    // check
    if (actual.getPaths().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPaths());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ImageSourceFluentImpl's pullSecret is equal to the given one.
   * @param pullSecret the given pullSecret to compare the actual ImageSourceFluentImpl's pullSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageSourceFluentImpl's pullSecret is not equal to the given one.
   */
  public S hasPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    // check that actual ImageSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pullSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPullSecret = actual.getPullSecret();
    if (!Objects.areEqual(actualPullSecret, pullSecret)) {
      failWithMessage(assertjErrorMessage, actual, pullSecret, actualPullSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
