package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IdentityFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIdentityFluentAssert<S extends AbstractIdentityFluentAssert<S, A>, A extends IdentityFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIdentityFluentAssert}</code> to make assertions on actual IdentityFluent.
   * @param actual the IdentityFluent we want to make assertions on.
   */
  protected AbstractIdentityFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IdentityFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IdentityFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual IdentityFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's extra is equal to the given one.
   * @param extra the given extra to compare the actual IdentityFluent's extra to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's extra is not equal to the given one.
   */
  public S hasExtra(java.util.Map extra) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting extra of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualExtra = actual.getExtra();
    if (!Objects.areEqual(actualExtra, extra)) {
      failWithMessage(assertjErrorMessage, actual, extra, actualExtra);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual IdentityFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual IdentityFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's providerName is equal to the given one.
   * @param providerName the given providerName to compare the actual IdentityFluent's providerName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's providerName is not equal to the given one.
   */
  public S hasProviderName(String providerName) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting providerName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProviderName = actual.getProviderName();
    if (!Objects.areEqual(actualProviderName, providerName)) {
      failWithMessage(assertjErrorMessage, actual, providerName, actualProviderName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's providerUserName is equal to the given one.
   * @param providerUserName the given providerUserName to compare the actual IdentityFluent's providerUserName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's providerUserName is not equal to the given one.
   */
  public S hasProviderUserName(String providerUserName) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting providerUserName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualProviderUserName = actual.getProviderUserName();
    if (!Objects.areEqual(actualProviderUserName, providerUserName)) {
      failWithMessage(assertjErrorMessage, actual, providerUserName, actualProviderUserName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IdentityFluent's user is equal to the given one.
   * @param user the given user to compare the actual IdentityFluent's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IdentityFluent's user is not equal to the given one.
   */
  public S hasUser(io.fabric8.kubernetes.api.model.ObjectReference user) {
    // check that actual IdentityFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
