package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GroupFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGroupFluentAssert<S extends AbstractGroupFluentAssert<S, A>, A extends GroupFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGroupFluentAssert}</code> to make assertions on actual GroupFluent.
   * @param actual the GroupFluent we want to make assertions on.
   */
  protected AbstractGroupFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GroupFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GroupFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual GroupFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual GroupFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual GroupFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GroupFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent's users contains the given String elements.
   * @param users the given elements that should be contained in actual GroupFluent's users.
   * @return this assertion object.
   * @throws AssertionError if the actual GroupFluent's users does not contain all given String elements.
   */
  public S hasUsers(String... users) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent's users contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param users the given elements that should be contained in actual GroupFluent's users.
   * @return this assertion object.
   * @throws AssertionError if the actual GroupFluent's users does not contain all given String elements.
   */
  public S hasOnlyUsers(String... users) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent's users does not contain the given String elements.
   *
   * @param users the given elements that should not be in actual GroupFluent's users.
   * @return this assertion object.
   * @throws AssertionError if the actual GroupFluent's users contains any given String elements.
   */
  public S doesNotHaveUsers(String... users) {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (users == null) failWithMessage("Expecting users parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getUsers(), users);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GroupFluent has no users.
   * @return this assertion object.
   * @throws AssertionError if the actual GroupFluent's users is not empty.
   */
  public S hasNoUsers() {
    // check that actual GroupFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have users but had :\n  <%s>";
    
    // check
    if (actual.getUsers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getUsers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
