package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ClusterRole} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractClusterRoleAssert<S extends AbstractClusterRoleAssert<S, A>, A extends ClusterRole> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractClusterRoleAssert}</code> to make assertions on actual ClusterRole.
   * @param actual the ClusterRole we want to make assertions on.
   */
  protected AbstractClusterRoleAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ClusterRole's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ClusterRole's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRole's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ClusterRole's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRole's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole's kind is equal to the given one.
   * @param kind the given kind to compare the actual ClusterRole's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRole's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ClusterRole's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ClusterRole's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole's rules contains the given PolicyRule elements.
   * @param rules the given elements that should be contained in actual ClusterRole's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterRole's rules does not contain all given PolicyRule elements.
   */
  public S hasRules(PolicyRule... rules) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // check that given PolicyRule varargs is not null.
    if (rules == null) failWithMessage("Expecting rules parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole's rules contains <b>only<b> the given PolicyRule elements and nothing else in whatever order.
   * @param rules the given elements that should be contained in actual ClusterRole's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterRole's rules does not contain all given PolicyRule elements.
   */
  public S hasOnlyRules(PolicyRule... rules) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // check that given PolicyRule varargs is not null.
    if (rules == null) failWithMessage("Expecting rules parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole's rules does not contain the given PolicyRule elements.
   *
   * @param rules the given elements that should not be in actual ClusterRole's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterRole's rules contains any given PolicyRule elements.
   */
  public S doesNotHaveRules(PolicyRule... rules) {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // check that given PolicyRule varargs is not null.
    if (rules == null) failWithMessage("Expecting rules parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ClusterRole has no rules.
   * @return this assertion object.
   * @throws AssertionError if the actual ClusterRole's rules is not empty.
   */
  public S hasNoRules() {
    // check that actual ClusterRole we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have rules but had :\n  <%s>";
    
    // check
    if (actual.getRules().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRules());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
