package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ReplicaSetListFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractReplicaSetListFluentAssert<S extends AbstractReplicaSetListFluentAssert<S, A>, A extends ReplicaSetListFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractReplicaSetListFluentAssert}</code> to make assertions on actual ReplicaSetListFluent.
   * @param actual the ReplicaSetListFluent we want to make assertions on.
   */
  protected AbstractReplicaSetListFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ReplicaSetListFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ReplicaSetListFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetListFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetListFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ReplicaSetListFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetListFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetListFluent's items contains the given ReplicaSet elements.
   * @param items the given elements that should be contained in actual ReplicaSetListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicaSetListFluent's items does not contain all given ReplicaSet elements.
   */
  public S hasItems(ReplicaSet... items) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicaSet varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetListFluent's items contains <b>only<b> the given ReplicaSet elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual ReplicaSetListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicaSetListFluent's items does not contain all given ReplicaSet elements.
   */
  public S hasOnlyItems(ReplicaSet... items) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicaSet varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetListFluent's items does not contain the given ReplicaSet elements.
   *
   * @param items the given elements that should not be in actual ReplicaSetListFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicaSetListFluent's items contains any given ReplicaSet elements.
   */
  public S doesNotHaveItems(ReplicaSet... items) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ReplicaSet varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetListFluent has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ReplicaSetListFluent's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ReplicaSetListFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual ReplicaSetListFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetListFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ReplicaSetListFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ReplicaSetListFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ReplicaSetListFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    // check that actual ReplicaSetListFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ListMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
