package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link JobSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJobSpecFluentImplAssert<S extends AbstractJobSpecFluentImplAssert<S, A>, A extends JobSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobSpecFluentImplAssert}</code> to make assertions on actual JobSpecFluentImpl.
   * @param actual the JobSpecFluentImpl we want to make assertions on.
   */
  protected AbstractJobSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JobSpecFluentImpl's activeDeadlineSeconds is equal to the given one.
   * @param activeDeadlineSeconds the given activeDeadlineSeconds to compare the actual JobSpecFluentImpl's activeDeadlineSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpecFluentImpl's activeDeadlineSeconds is not equal to the given one.
   */
  public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    // check that actual JobSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualActiveDeadlineSeconds = actual.getActiveDeadlineSeconds();
    if (!Objects.areEqual(actualActiveDeadlineSeconds, activeDeadlineSeconds)) {
      failWithMessage(assertjErrorMessage, actual, activeDeadlineSeconds, actualActiveDeadlineSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual JobSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual JobSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobSpecFluentImpl's completions is equal to the given one.
   * @param completions the given completions to compare the actual JobSpecFluentImpl's completions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpecFluentImpl's completions is not equal to the given one.
   */
  public S hasCompletions(Integer completions) {
    // check that actual JobSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting completions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualCompletions = actual.getCompletions();
    if (!Objects.areEqual(actualCompletions, completions)) {
      failWithMessage(assertjErrorMessage, actual, completions, actualCompletions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobSpecFluentImpl's parallelism is equal to the given one.
   * @param parallelism the given parallelism to compare the actual JobSpecFluentImpl's parallelism to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpecFluentImpl's parallelism is not equal to the given one.
   */
  public S hasParallelism(Integer parallelism) {
    // check that actual JobSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting parallelism of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualParallelism = actual.getParallelism();
    if (!Objects.areEqual(actualParallelism, parallelism)) {
      failWithMessage(assertjErrorMessage, actual, parallelism, actualParallelism);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobSpecFluentImpl's selector is equal to the given one.
   * @param selector the given selector to compare the actual JobSpecFluentImpl's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpecFluentImpl's selector is not equal to the given one.
   */
  public S hasSelector(LabelSelector selector) {
    // check that actual JobSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LabelSelector actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobSpecFluentImpl's template is equal to the given one.
   * @param template the given template to compare the actual JobSpecFluentImpl's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobSpecFluentImpl's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual JobSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
