package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DaemonSetSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetSpecAssert<S extends AbstractDaemonSetSpecAssert<S, A>, A extends DaemonSetSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetSpecAssert}</code> to make assertions on actual DaemonSetSpec.
   * @param actual the DaemonSetSpec we want to make assertions on.
   */
  protected AbstractDaemonSetSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DaemonSetSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DaemonSetSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpec's selector is equal to the given one.
   * @param selector the given selector to compare the actual DaemonSetSpec's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpec's selector is not equal to the given one.
   */
  public S hasSelector(LabelSelector selector) {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LabelSelector actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpec's template is equal to the given one.
   * @param template the given template to compare the actual DaemonSetSpec's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpec's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual DaemonSetSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
