package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodStatusFluentAssert<S extends AbstractPodStatusFluentAssert<S, A>, A extends PodStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodStatusFluentAssert}</code> to make assertions on actual PodStatusFluent.
   * @param actual the PodStatusFluent we want to make assertions on.
   */
  protected AbstractPodStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's conditions contains the given PodCondition elements.
   * @param conditions the given elements that should be contained in actual PodStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's conditions does not contain all given PodCondition elements.
   */
  public S hasConditions(PodCondition... conditions) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given PodCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's conditions contains <b>only<b> the given PodCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual PodStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's conditions does not contain all given PodCondition elements.
   */
  public S hasOnlyConditions(PodCondition... conditions) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given PodCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's conditions does not contain the given PodCondition elements.
   *
   * @param conditions the given elements that should not be in actual PodStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's conditions contains any given PodCondition elements.
   */
  public S doesNotHaveConditions(PodCondition... conditions) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given PodCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodStatusFluent's containerStatuses contains the given ContainerStatus elements.
   * @param containerStatuses the given elements that should be contained in actual PodStatusFluent's containerStatuses.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's containerStatuses does not contain all given ContainerStatus elements.
   */
  public S hasContainerStatuses(ContainerStatus... containerStatuses) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerStatus varargs is not null.
    if (containerStatuses == null) failWithMessage("Expecting containerStatuses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContainerStatuses(), containerStatuses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's containerStatuses contains <b>only<b> the given ContainerStatus elements and nothing else in whatever order.
   * @param containerStatuses the given elements that should be contained in actual PodStatusFluent's containerStatuses.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's containerStatuses does not contain all given ContainerStatus elements.
   */
  public S hasOnlyContainerStatuses(ContainerStatus... containerStatuses) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerStatus varargs is not null.
    if (containerStatuses == null) failWithMessage("Expecting containerStatuses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getContainerStatuses(), containerStatuses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's containerStatuses does not contain the given ContainerStatus elements.
   *
   * @param containerStatuses the given elements that should not be in actual PodStatusFluent's containerStatuses.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's containerStatuses contains any given ContainerStatus elements.
   */
  public S doesNotHaveContainerStatuses(ContainerStatus... containerStatuses) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerStatus varargs is not null.
    if (containerStatuses == null) failWithMessage("Expecting containerStatuses parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getContainerStatuses(), containerStatuses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent has no containerStatuses.
   * @return this assertion object.
   * @throws AssertionError if the actual PodStatusFluent's containerStatuses is not empty.
   */
  public S hasNoContainerStatuses() {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have containerStatuses but had :\n  <%s>";
    
    // check
    if (actual.getContainerStatuses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContainerStatuses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PodStatusFluent's hostIP is equal to the given one.
   * @param hostIP the given hostIP to compare the actual PodStatusFluent's hostIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's hostIP is not equal to the given one.
   */
  public S hasHostIP(String hostIP) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting hostIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHostIP = actual.getHostIP();
    if (!Objects.areEqual(actualHostIP, hostIP)) {
      failWithMessage(assertjErrorMessage, actual, hostIP, actualHostIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's message is equal to the given one.
   * @param message the given message to compare the actual PodStatusFluent's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's phase is equal to the given one.
   * @param phase the given phase to compare the actual PodStatusFluent's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's podIP is equal to the given one.
   * @param podIP the given podIP to compare the actual PodStatusFluent's podIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's podIP is not equal to the given one.
   */
  public S hasPodIP(String podIP) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting podIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPodIP = actual.getPodIP();
    if (!Objects.areEqual(actualPodIP, podIP)) {
      failWithMessage(assertjErrorMessage, actual, podIP, actualPodIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's reason is equal to the given one.
   * @param reason the given reason to compare the actual PodStatusFluent's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodStatusFluent's startTime is equal to the given one.
   * @param startTime the given startTime to compare the actual PodStatusFluent's startTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodStatusFluent's startTime is not equal to the given one.
   */
  public S hasStartTime(String startTime) {
    // check that actual PodStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting startTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStartTime = actual.getStartTime();
    if (!Objects.areEqual(actualStartTime, startTime)) {
      failWithMessage(assertjErrorMessage, actual, startTime, actualStartTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
