package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KeyToPathFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKeyToPathFluentImplAssert<S extends AbstractKeyToPathFluentImplAssert<S, A>, A extends KeyToPathFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKeyToPathFluentImplAssert}</code> to make assertions on actual KeyToPathFluentImpl.
   * @param actual the KeyToPathFluentImpl we want to make assertions on.
   */
  protected AbstractKeyToPathFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KeyToPathFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KeyToPathFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPathFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KeyToPathFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KeyToPathFluentImpl's key is equal to the given one.
   * @param key the given key to compare the actual KeyToPathFluentImpl's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPathFluentImpl's key is not equal to the given one.
   */
  public S hasKey(String key) {
    // check that actual KeyToPathFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKey = actual.getKey();
    if (!Objects.areEqual(actualKey, key)) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KeyToPathFluentImpl's path is equal to the given one.
   * @param path the given path to compare the actual KeyToPathFluentImpl's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPathFluentImpl's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual KeyToPathFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
