package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HTTPGetAction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPGetActionAssert<S extends AbstractHTTPGetActionAssert<S, A>, A extends HTTPGetAction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPGetActionAssert}</code> to make assertions on actual HTTPGetAction.
   * @param actual the HTTPGetAction we want to make assertions on.
   */
  protected AbstractHTTPGetActionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HTTPGetAction's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HTTPGetAction's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetAction's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction's host is equal to the given one.
   * @param host the given host to compare the actual HTTPGetAction's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetAction's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction's httpHeaders contains the given HTTPHeader elements.
   * @param httpHeaders the given elements that should be contained in actual HTTPGetAction's httpHeaders.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPGetAction's httpHeaders does not contain all given HTTPHeader elements.
   */
  public S hasHttpHeaders(HTTPHeader... httpHeaders) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // check that given HTTPHeader varargs is not null.
    if (httpHeaders == null) failWithMessage("Expecting httpHeaders parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getHttpHeaders(), httpHeaders);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction's httpHeaders contains <b>only<b> the given HTTPHeader elements and nothing else in whatever order.
   * @param httpHeaders the given elements that should be contained in actual HTTPGetAction's httpHeaders.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPGetAction's httpHeaders does not contain all given HTTPHeader elements.
   */
  public S hasOnlyHttpHeaders(HTTPHeader... httpHeaders) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // check that given HTTPHeader varargs is not null.
    if (httpHeaders == null) failWithMessage("Expecting httpHeaders parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getHttpHeaders(), httpHeaders);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction's httpHeaders does not contain the given HTTPHeader elements.
   *
   * @param httpHeaders the given elements that should not be in actual HTTPGetAction's httpHeaders.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPGetAction's httpHeaders contains any given HTTPHeader elements.
   */
  public S doesNotHaveHttpHeaders(HTTPHeader... httpHeaders) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // check that given HTTPHeader varargs is not null.
    if (httpHeaders == null) failWithMessage("Expecting httpHeaders parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getHttpHeaders(), httpHeaders);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction has no httpHeaders.
   * @return this assertion object.
   * @throws AssertionError if the actual HTTPGetAction's httpHeaders is not empty.
   */
  public S hasNoHttpHeaders() {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have httpHeaders but had :\n  <%s>";
    
    // check
    if (actual.getHttpHeaders().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getHttpHeaders());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual HTTPGetAction's path is equal to the given one.
   * @param path the given path to compare the actual HTTPGetAction's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetAction's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction's port is equal to the given one.
   * @param port the given port to compare the actual HTTPGetAction's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetAction's port is not equal to the given one.
   */
  public S hasPort(IntOrString port) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    IntOrString actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetAction's scheme is equal to the given one.
   * @param scheme the given scheme to compare the actual HTTPGetAction's scheme to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetAction's scheme is not equal to the given one.
   */
  public S hasScheme(String scheme) {
    // check that actual HTTPGetAction we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scheme of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualScheme = actual.getScheme();
    if (!Objects.areEqual(actualScheme, scheme)) {
      failWithMessage(assertjErrorMessage, actual, scheme, actualScheme);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
