package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerImageFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerImageFluentAssert<S extends AbstractContainerImageFluentAssert<S, A>, A extends ContainerImageFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerImageFluentAssert}</code> to make assertions on actual ContainerImageFluent.
   * @param actual the ContainerImageFluent we want to make assertions on.
   */
  protected AbstractContainerImageFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerImageFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerImageFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerImageFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent's names contains the given String elements.
   * @param names the given elements that should be contained in actual ContainerImageFluent's names.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's names does not contain all given String elements.
   */
  public S hasNames(String... names) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (names == null) failWithMessage("Expecting names parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getNames(), names);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent's names contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param names the given elements that should be contained in actual ContainerImageFluent's names.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's names does not contain all given String elements.
   */
  public S hasOnlyNames(String... names) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (names == null) failWithMessage("Expecting names parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getNames(), names);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent's names does not contain the given String elements.
   *
   * @param names the given elements that should not be in actual ContainerImageFluent's names.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's names contains any given String elements.
   */
  public S doesNotHaveNames(String... names) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (names == null) failWithMessage("Expecting names parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getNames(), names);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent has no names.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's names is not empty.
   */
  public S hasNoNames() {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have names but had :\n  <%s>";
    
    // check
    if (actual.getNames().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getNames());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerImageFluent's sizeBytes is equal to the given one.
   * @param sizeBytes the given sizeBytes to compare the actual ContainerImageFluent's sizeBytes to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerImageFluent's sizeBytes is not equal to the given one.
   */
  public S hasSizeBytes(Long sizeBytes) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sizeBytes of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualSizeBytes = actual.getSizeBytes();
    if (!Objects.areEqual(actualSizeBytes, sizeBytes)) {
      failWithMessage(assertjErrorMessage, actual, sizeBytes, actualSizeBytes);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
