package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CephFSVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCephFSVolumeSourceAssert<S extends AbstractCephFSVolumeSourceAssert<S, A>, A extends CephFSVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCephFSVolumeSourceAssert}</code> to make assertions on actual CephFSVolumeSource.
   * @param actual the CephFSVolumeSource we want to make assertions on.
   */
  protected AbstractCephFSVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CephFSVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CephFSVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's monitors contains the given String elements.
   * @param monitors the given elements that should be contained in actual CephFSVolumeSource's monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual CephFSVolumeSource's monitors does not contain all given String elements.
   */
  public S hasMonitors(String... monitors) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (monitors == null) failWithMessage("Expecting monitors parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMonitors(), monitors);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's monitors contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param monitors the given elements that should be contained in actual CephFSVolumeSource's monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual CephFSVolumeSource's monitors does not contain all given String elements.
   */
  public S hasOnlyMonitors(String... monitors) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (monitors == null) failWithMessage("Expecting monitors parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getMonitors(), monitors);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's monitors does not contain the given String elements.
   *
   * @param monitors the given elements that should not be in actual CephFSVolumeSource's monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual CephFSVolumeSource's monitors contains any given String elements.
   */
  public S doesNotHaveMonitors(String... monitors) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (monitors == null) failWithMessage("Expecting monitors parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getMonitors(), monitors);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource has no monitors.
   * @return this assertion object.
   * @throws AssertionError if the actual CephFSVolumeSource's monitors is not empty.
   */
  public S hasNoMonitors() {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have monitors but had :\n  <%s>";
    
    // check
    if (actual.getMonitors().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getMonitors());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CephFSVolumeSource's path is equal to the given one.
   * @param path the given path to compare the actual CephFSVolumeSource's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSource's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's readOnly is equal to the given one.
   * @param readOnly the given readOnly to compare the actual CephFSVolumeSource's readOnly to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSource's readOnly is not equal to the given one.
   */
  public S hasReadOnly(Boolean readOnly) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readOnly of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReadOnly = actual.getReadOnly();
    if (!Objects.areEqual(actualReadOnly, readOnly)) {
      failWithMessage(assertjErrorMessage, actual, readOnly, actualReadOnly);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's secretFile is equal to the given one.
   * @param secretFile the given secretFile to compare the actual CephFSVolumeSource's secretFile to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSource's secretFile is not equal to the given one.
   */
  public S hasSecretFile(String secretFile) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretFile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecretFile = actual.getSecretFile();
    if (!Objects.areEqual(actualSecretFile, secretFile)) {
      failWithMessage(assertjErrorMessage, actual, secretFile, actualSecretFile);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's secretRef is equal to the given one.
   * @param secretRef the given secretRef to compare the actual CephFSVolumeSource's secretRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSource's secretRef is not equal to the given one.
   */
  public S hasSecretRef(LocalObjectReference secretRef) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LocalObjectReference actualSecretRef = actual.getSecretRef();
    if (!Objects.areEqual(actualSecretRef, secretRef)) {
      failWithMessage(assertjErrorMessage, actual, secretRef, actualSecretRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CephFSVolumeSource's user is equal to the given one.
   * @param user the given user to compare the actual CephFSVolumeSource's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CephFSVolumeSource's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual CephFSVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
