package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link UserFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractUserFluentAssert<S extends AbstractUserFluentAssert<S, A>, A extends UserFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractUserFluentAssert}</code> to make assertions on actual UserFluent.
   * @param actual the UserFluent we want to make assertions on.
   */
  protected AbstractUserFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual UserFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual UserFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual UserFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual UserFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual UserFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's fullName is equal to the given one.
   * @param fullName the given fullName to compare the actual UserFluent's fullName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual UserFluent's fullName is not equal to the given one.
   */
  public S hasFullName(String fullName) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fullName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFullName = actual.getFullName();
    if (!Objects.areEqual(actualFullName, fullName)) {
      failWithMessage(assertjErrorMessage, actual, fullName, actualFullName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual UserFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's groups contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param groups the given elements that should be contained in actual UserFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's groups does not contain all given String elements.
   */
  public S hasOnlyGroups(String... groups) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's groups does not contain the given String elements.
   *
   * @param groups the given elements that should not be in actual UserFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's groups contains any given String elements.
   */
  public S doesNotHaveGroups(String... groups) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual UserFluent's identities contains the given String elements.
   * @param identities the given elements that should be contained in actual UserFluent's identities.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's identities does not contain all given String elements.
   */
  public S hasIdentities(String... identities) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (identities == null) failWithMessage("Expecting identities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getIdentities(), identities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's identities contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param identities the given elements that should be contained in actual UserFluent's identities.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's identities does not contain all given String elements.
   */
  public S hasOnlyIdentities(String... identities) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (identities == null) failWithMessage("Expecting identities parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getIdentities(), identities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's identities does not contain the given String elements.
   *
   * @param identities the given elements that should not be in actual UserFluent's identities.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's identities contains any given String elements.
   */
  public S doesNotHaveIdentities(String... identities) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (identities == null) failWithMessage("Expecting identities parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getIdentities(), identities);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent has no identities.
   * @return this assertion object.
   * @throws AssertionError if the actual UserFluent's identities is not empty.
   */
  public S hasNoIdentities() {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have identities but had :\n  <%s>";
    
    // check
    if (actual.getIdentities().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getIdentities());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual UserFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual UserFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual UserFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual UserFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual UserFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual UserFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual UserFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
