package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TagReferenceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagReferenceFluentImplAssert<S extends AbstractTagReferenceFluentImplAssert<S, A>, A extends TagReferenceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagReferenceFluentImplAssert}</code> to make assertions on actual TagReferenceFluentImpl.
   * @param actual the TagReferenceFluentImpl we want to make assertions on.
   */
  protected AbstractTagReferenceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TagReferenceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TagReferenceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReferenceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TagReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReferenceFluentImpl's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual TagReferenceFluentImpl's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReferenceFluentImpl's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual TagReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReferenceFluentImpl's from is equal to the given one.
   * @param from the given from to compare the actual TagReferenceFluentImpl's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReferenceFluentImpl's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual TagReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReferenceFluentImpl's generation is equal to the given one.
   * @param generation the given generation to compare the actual TagReferenceFluentImpl's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReferenceFluentImpl's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual TagReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReferenceFluentImpl's importPolicy is equal to the given one.
   * @param importPolicy the given importPolicy to compare the actual TagReferenceFluentImpl's importPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReferenceFluentImpl's importPolicy is not equal to the given one.
   */
  public S hasImportPolicy(TagImportPolicy importPolicy) {
    // check that actual TagReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting importPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    TagImportPolicy actualImportPolicy = actual.getImportPolicy();
    if (!Objects.areEqual(actualImportPolicy, importPolicy)) {
      failWithMessage(assertjErrorMessage, actual, importPolicy, actualImportPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReferenceFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual TagReferenceFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReferenceFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual TagReferenceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
