package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TagReference} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagReferenceAssert<S extends AbstractTagReferenceAssert<S, A>, A extends TagReference> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagReferenceAssert}</code> to make assertions on actual TagReference.
   * @param actual the TagReference we want to make assertions on.
   */
  protected AbstractTagReferenceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TagReference's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TagReference's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReference's annotations is equal to the given one.
   * @param annotations the given annotations to compare the actual TagReference's annotations to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's annotations is not equal to the given one.
   */
  public S hasAnnotations(java.util.Map annotations) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAnnotations = actual.getAnnotations();
    if (!Objects.areEqual(actualAnnotations, annotations)) {
      failWithMessage(assertjErrorMessage, actual, annotations, actualAnnotations);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReference's from is equal to the given one.
   * @param from the given from to compare the actual TagReference's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReference's generation is equal to the given one.
   * @param generation the given generation to compare the actual TagReference's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReference's importPolicy is equal to the given one.
   * @param importPolicy the given importPolicy to compare the actual TagReference's importPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's importPolicy is not equal to the given one.
   */
  public S hasImportPolicy(TagImportPolicy importPolicy) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting importPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    TagImportPolicy actualImportPolicy = actual.getImportPolicy();
    if (!Objects.areEqual(actualImportPolicy, importPolicy)) {
      failWithMessage(assertjErrorMessage, actual, importPolicy, actualImportPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReference's name is equal to the given one.
   * @param name the given name to compare the actual TagReference's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagReference's reference is equal to the given one.
   * @param reference the given reference to compare the actual TagReference's reference to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagReference's reference is not equal to the given one.
   */
  public S hasReference(Boolean reference) {
    // check that actual TagReference we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reference of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReference = actual.getReference();
    if (!Objects.areEqual(actualReference, reference)) {
      failWithMessage(assertjErrorMessage, actual, reference, actualReference);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
