package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link TagEventFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractTagEventFluentImplAssert<S extends AbstractTagEventFluentImplAssert<S, A>, A extends TagEventFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractTagEventFluentImplAssert}</code> to make assertions on actual TagEventFluentImpl.
   * @param actual the TagEventFluentImpl we want to make assertions on.
   */
  protected AbstractTagEventFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual TagEventFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual TagEventFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEventFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual TagEventFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEventFluentImpl's created is equal to the given one.
   * @param created the given created to compare the actual TagEventFluentImpl's created to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEventFluentImpl's created is not equal to the given one.
   */
  public S hasCreated(String created) {
    // check that actual TagEventFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting created of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCreated = actual.getCreated();
    if (!Objects.areEqual(actualCreated, created)) {
      failWithMessage(assertjErrorMessage, actual, created, actualCreated);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEventFluentImpl's dockerImageReference is equal to the given one.
   * @param dockerImageReference the given dockerImageReference to compare the actual TagEventFluentImpl's dockerImageReference to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEventFluentImpl's dockerImageReference is not equal to the given one.
   */
  public S hasDockerImageReference(String dockerImageReference) {
    // check that actual TagEventFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageReference of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageReference = actual.getDockerImageReference();
    if (!Objects.areEqual(actualDockerImageReference, dockerImageReference)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageReference, actualDockerImageReference);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEventFluentImpl's generation is equal to the given one.
   * @param generation the given generation to compare the actual TagEventFluentImpl's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEventFluentImpl's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual TagEventFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual TagEventFluentImpl's image is equal to the given one.
   * @param image the given image to compare the actual TagEventFluentImpl's image to.
   * @return this assertion object.
   * @throws AssertionError - if the actual TagEventFluentImpl's image is not equal to the given one.
   */
  public S hasImage(String image) {
    // check that actual TagEventFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting image of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualImage = actual.getImage();
    if (!Objects.areEqual(actualImage, image)) {
      failWithMessage(assertjErrorMessage, actual, image, actualImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
