package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SubjectAccessReviewFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectAccessReviewFluentAssert<S extends AbstractSubjectAccessReviewFluentAssert<S, A>, A extends SubjectAccessReviewFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectAccessReviewFluentAssert}</code> to make assertions on actual SubjectAccessReviewFluent.
   * @param actual the SubjectAccessReviewFluent we want to make assertions on.
   */
  protected AbstractSubjectAccessReviewFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SubjectAccessReviewFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual SubjectAccessReviewFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's content is equal to the given one.
   * @param content the given content to compare the actual SubjectAccessReviewFluent's content to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's content is not equal to the given one.
   */
  public S hasContent(io.fabric8.kubernetes.api.model.HasMetadata content) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting content of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.HasMetadata actualContent = actual.getContent();
    if (!Objects.areEqual(actualContent, content)) {
      failWithMessage(assertjErrorMessage, actual, content, actualContent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's groups contains the given String elements.
   * @param groups the given elements that should be contained in actual SubjectAccessReviewFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SubjectAccessReviewFluent's groups does not contain all given String elements.
   */
  public S hasGroups(String... groups) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's groups contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param groups the given elements that should be contained in actual SubjectAccessReviewFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SubjectAccessReviewFluent's groups does not contain all given String elements.
   */
  public S hasOnlyGroups(String... groups) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's groups does not contain the given String elements.
   *
   * @param groups the given elements that should not be in actual SubjectAccessReviewFluent's groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SubjectAccessReviewFluent's groups contains any given String elements.
   */
  public S doesNotHaveGroups(String... groups) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (groups == null) failWithMessage("Expecting groups parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getGroups(), groups);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent has no groups.
   * @return this assertion object.
   * @throws AssertionError if the actual SubjectAccessReviewFluent's groups is not empty.
   */
  public S hasNoGroups() {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have groups but had :\n  <%s>";
    
    // check
    if (actual.getGroups().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getGroups());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual SubjectAccessReviewFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual SubjectAccessReviewFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual SubjectAccessReviewFluent's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's namespace is not equal to the given one.
   */
  public S hasNamespace(String namespace) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's resource is equal to the given one.
   * @param resource the given resource to compare the actual SubjectAccessReviewFluent's resource to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's resource is not equal to the given one.
   */
  public S hasResource(String resource) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resource of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResource = actual.getResource();
    if (!Objects.areEqual(actualResource, resource)) {
      failWithMessage(assertjErrorMessage, actual, resource, actualResource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's resourceAPIGroup is equal to the given one.
   * @param resourceAPIGroup the given resourceAPIGroup to compare the actual SubjectAccessReviewFluent's resourceAPIGroup to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's resourceAPIGroup is not equal to the given one.
   */
  public S hasResourceAPIGroup(String resourceAPIGroup) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceAPIGroup of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceAPIGroup = actual.getResourceAPIGroup();
    if (!Objects.areEqual(actualResourceAPIGroup, resourceAPIGroup)) {
      failWithMessage(assertjErrorMessage, actual, resourceAPIGroup, actualResourceAPIGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's resourceAPIVersion is equal to the given one.
   * @param resourceAPIVersion the given resourceAPIVersion to compare the actual SubjectAccessReviewFluent's resourceAPIVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's resourceAPIVersion is not equal to the given one.
   */
  public S hasResourceAPIVersion(String resourceAPIVersion) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceAPIVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceAPIVersion = actual.getResourceAPIVersion();
    if (!Objects.areEqual(actualResourceAPIVersion, resourceAPIVersion)) {
      failWithMessage(assertjErrorMessage, actual, resourceAPIVersion, actualResourceAPIVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's resourceName is equal to the given one.
   * @param resourceName the given resourceName to compare the actual SubjectAccessReviewFluent's resourceName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's resourceName is not equal to the given one.
   */
  public S hasResourceName(String resourceName) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualResourceName = actual.getResourceName();
    if (!Objects.areEqual(actualResourceName, resourceName)) {
      failWithMessage(assertjErrorMessage, actual, resourceName, actualResourceName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's user is equal to the given one.
   * @param user the given user to compare the actual SubjectAccessReviewFluent's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's user is not equal to the given one.
   */
  public S hasUser(String user) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SubjectAccessReviewFluent's verb is equal to the given one.
   * @param verb the given verb to compare the actual SubjectAccessReviewFluent's verb to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SubjectAccessReviewFluent's verb is not equal to the given one.
   */
  public S hasVerb(String verb) {
    // check that actual SubjectAccessReviewFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting verb of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualVerb = actual.getVerb();
    if (!Objects.areEqual(actualVerb, verb)) {
      failWithMessage(assertjErrorMessage, actual, verb, actualVerb);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
