package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RouteStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteStatusAssert<S extends AbstractRouteStatusAssert<S, A>, A extends RouteStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteStatusAssert}</code> to make assertions on actual RouteStatus.
   * @param actual the RouteStatus we want to make assertions on.
   */
  protected AbstractRouteStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RouteStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RouteStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RouteStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteStatus's ingress contains the given RouteIngress elements.
   * @param ingress the given elements that should be contained in actual RouteStatus's ingress.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteStatus's ingress does not contain all given RouteIngress elements.
   */
  public S hasIngress(RouteIngress... ingress) {
    // check that actual RouteStatus we want to make assertions on is not null.
    isNotNull();

    // check that given RouteIngress varargs is not null.
    if (ingress == null) failWithMessage("Expecting ingress parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getIngress(), ingress);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteStatus's ingress contains <b>only<b> the given RouteIngress elements and nothing else in whatever order.
   * @param ingress the given elements that should be contained in actual RouteStatus's ingress.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteStatus's ingress does not contain all given RouteIngress elements.
   */
  public S hasOnlyIngress(RouteIngress... ingress) {
    // check that actual RouteStatus we want to make assertions on is not null.
    isNotNull();

    // check that given RouteIngress varargs is not null.
    if (ingress == null) failWithMessage("Expecting ingress parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getIngress(), ingress);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteStatus's ingress does not contain the given RouteIngress elements.
   *
   * @param ingress the given elements that should not be in actual RouteStatus's ingress.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteStatus's ingress contains any given RouteIngress elements.
   */
  public S doesNotHaveIngress(RouteIngress... ingress) {
    // check that actual RouteStatus we want to make assertions on is not null.
    isNotNull();

    // check that given RouteIngress varargs is not null.
    if (ingress == null) failWithMessage("Expecting ingress parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getIngress(), ingress);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteStatus has no ingress.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteStatus's ingress is not empty.
   */
  public S hasNoIngress() {
    // check that actual RouteStatus we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have ingress but had :\n  <%s>";
    
    // check
    if (actual.getIngress().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getIngress());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
