package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProjectRequestFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProjectRequestFluentImplAssert<S extends AbstractProjectRequestFluentImplAssert<S, A>, A extends ProjectRequestFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProjectRequestFluentImplAssert}</code> to make assertions on actual ProjectRequestFluentImpl.
   * @param actual the ProjectRequestFluentImpl we want to make assertions on.
   */
  protected AbstractProjectRequestFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProjectRequestFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ProjectRequestFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectRequestFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ProjectRequestFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectRequestFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ProjectRequestFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectRequestFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ProjectRequestFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectRequestFluentImpl's description is equal to the given one.
   * @param description the given description to compare the actual ProjectRequestFluentImpl's description to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectRequestFluentImpl's description is not equal to the given one.
   */
  public S hasDescription(String description) {
    // check that actual ProjectRequestFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDescription = actual.getDescription();
    if (!Objects.areEqual(actualDescription, description)) {
      failWithMessage(assertjErrorMessage, actual, description, actualDescription);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectRequestFluentImpl's displayName is equal to the given one.
   * @param displayName the given displayName to compare the actual ProjectRequestFluentImpl's displayName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectRequestFluentImpl's displayName is not equal to the given one.
   */
  public S hasDisplayName(String displayName) {
    // check that actual ProjectRequestFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting displayName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDisplayName = actual.getDisplayName();
    if (!Objects.areEqual(actualDisplayName, displayName)) {
      failWithMessage(assertjErrorMessage, actual, displayName, actualDisplayName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectRequestFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ProjectRequestFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectRequestFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ProjectRequestFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectRequestFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ProjectRequestFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectRequestFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ProjectRequestFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
