package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageFluentImplAssert<S extends AbstractImageFluentImplAssert<S, A>, A extends ImageFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageFluentImplAssert}</code> to make assertions on actual ImageFluentImpl.
   * @param actual the ImageFluentImpl we want to make assertions on.
   */
  protected AbstractImageFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ImageFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageLayers contains the given ImageLayer elements.
   * @param dockerImageLayers the given elements that should be contained in actual ImageFluentImpl's dockerImageLayers.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageFluentImpl's dockerImageLayers does not contain all given ImageLayer elements.
   */
  public S hasDockerImageLayers(ImageLayer... dockerImageLayers) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ImageLayer varargs is not null.
    if (dockerImageLayers == null) failWithMessage("Expecting dockerImageLayers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDockerImageLayers(), dockerImageLayers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageLayers contains <b>only<b> the given ImageLayer elements and nothing else in whatever order.
   * @param dockerImageLayers the given elements that should be contained in actual ImageFluentImpl's dockerImageLayers.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageFluentImpl's dockerImageLayers does not contain all given ImageLayer elements.
   */
  public S hasOnlyDockerImageLayers(ImageLayer... dockerImageLayers) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ImageLayer varargs is not null.
    if (dockerImageLayers == null) failWithMessage("Expecting dockerImageLayers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getDockerImageLayers(), dockerImageLayers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageLayers does not contain the given ImageLayer elements.
   *
   * @param dockerImageLayers the given elements that should not be in actual ImageFluentImpl's dockerImageLayers.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageFluentImpl's dockerImageLayers contains any given ImageLayer elements.
   */
  public S doesNotHaveDockerImageLayers(ImageLayer... dockerImageLayers) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ImageLayer varargs is not null.
    if (dockerImageLayers == null) failWithMessage("Expecting dockerImageLayers parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getDockerImageLayers(), dockerImageLayers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl has no dockerImageLayers.
   * @return this assertion object.
   * @throws AssertionError if the actual ImageFluentImpl's dockerImageLayers is not empty.
   */
  public S hasNoDockerImageLayers() {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have dockerImageLayers but had :\n  <%s>";
    
    // check
    if (actual.getDockerImageLayers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getDockerImageLayers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageManifest is equal to the given one.
   * @param dockerImageManifest the given dockerImageManifest to compare the actual ImageFluentImpl's dockerImageManifest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's dockerImageManifest is not equal to the given one.
   */
  public S hasDockerImageManifest(String dockerImageManifest) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageManifest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageManifest = actual.getDockerImageManifest();
    if (!Objects.areEqual(actualDockerImageManifest, dockerImageManifest)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageManifest, actualDockerImageManifest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageMetadata is equal to the given one.
   * @param dockerImageMetadata the given dockerImageMetadata to compare the actual ImageFluentImpl's dockerImageMetadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's dockerImageMetadata is not equal to the given one.
   */
  public S hasDockerImageMetadata(io.fabric8.kubernetes.api.model.HasMetadata dockerImageMetadata) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageMetadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.HasMetadata actualDockerImageMetadata = actual.getDockerImageMetadata();
    if (!Objects.areEqual(actualDockerImageMetadata, dockerImageMetadata)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageMetadata, actualDockerImageMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageMetadataVersion is equal to the given one.
   * @param dockerImageMetadataVersion the given dockerImageMetadataVersion to compare the actual ImageFluentImpl's dockerImageMetadataVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's dockerImageMetadataVersion is not equal to the given one.
   */
  public S hasDockerImageMetadataVersion(String dockerImageMetadataVersion) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageMetadataVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageMetadataVersion = actual.getDockerImageMetadataVersion();
    if (!Objects.areEqual(actualDockerImageMetadataVersion, dockerImageMetadataVersion)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageMetadataVersion, actualDockerImageMetadataVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's dockerImageReference is equal to the given one.
   * @param dockerImageReference the given dockerImageReference to compare the actual ImageFluentImpl's dockerImageReference to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's dockerImageReference is not equal to the given one.
   */
  public S hasDockerImageReference(String dockerImageReference) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerImageReference of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerImageReference = actual.getDockerImageReference();
    if (!Objects.areEqual(actualDockerImageReference, dockerImageReference)) {
      failWithMessage(assertjErrorMessage, actual, dockerImageReference, actualDockerImageReference);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ImageFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ImageFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ImageFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
