package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ThirdPartyResourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractThirdPartyResourceFluentImplAssert<S extends AbstractThirdPartyResourceFluentImplAssert<S, A>, A extends ThirdPartyResourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractThirdPartyResourceFluentImplAssert}</code> to make assertions on actual ThirdPartyResourceFluentImpl.
   * @param actual the ThirdPartyResourceFluentImpl we want to make assertions on.
   */
  protected AbstractThirdPartyResourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ThirdPartyResourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ThirdPartyResourceFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResourceFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's description is equal to the given one.
   * @param description the given description to compare the actual ThirdPartyResourceFluentImpl's description to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResourceFluentImpl's description is not equal to the given one.
   */
  public S hasDescription(String description) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDescription = actual.getDescription();
    if (!Objects.areEqual(actualDescription, description)) {
      failWithMessage(assertjErrorMessage, actual, description, actualDescription);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ThirdPartyResourceFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResourceFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ThirdPartyResourceFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ThirdPartyResourceFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's versions contains the given APIVersion elements.
   * @param versions the given elements that should be contained in actual ThirdPartyResourceFluentImpl's versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResourceFluentImpl's versions does not contain all given APIVersion elements.
   */
  public S hasVersions(APIVersion... versions) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given APIVersion varargs is not null.
    if (versions == null) failWithMessage("Expecting versions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getVersions(), versions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's versions contains <b>only<b> the given APIVersion elements and nothing else in whatever order.
   * @param versions the given elements that should be contained in actual ThirdPartyResourceFluentImpl's versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResourceFluentImpl's versions does not contain all given APIVersion elements.
   */
  public S hasOnlyVersions(APIVersion... versions) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given APIVersion varargs is not null.
    if (versions == null) failWithMessage("Expecting versions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getVersions(), versions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl's versions does not contain the given APIVersion elements.
   *
   * @param versions the given elements that should not be in actual ThirdPartyResourceFluentImpl's versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResourceFluentImpl's versions contains any given APIVersion elements.
   */
  public S doesNotHaveVersions(APIVersion... versions) {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given APIVersion varargs is not null.
    if (versions == null) failWithMessage("Expecting versions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getVersions(), versions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ThirdPartyResourceFluentImpl has no versions.
   * @return this assertion object.
   * @throws AssertionError if the actual ThirdPartyResourceFluentImpl's versions is not empty.
   */
  public S hasNoVersions() {
    // check that actual ThirdPartyResourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have versions but had :\n  <%s>";
    
    // check
    if (actual.getVersions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getVersions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
