package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ScaleStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScaleStatusFluentAssert<S extends AbstractScaleStatusFluentAssert<S, A>, A extends ScaleStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScaleStatusFluentAssert}</code> to make assertions on actual ScaleStatusFluent.
   * @param actual the ScaleStatusFluent we want to make assertions on.
   */
  protected AbstractScaleStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ScaleStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ScaleStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ScaleStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ScaleStatusFluent's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ScaleStatusFluent's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleStatusFluent's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ScaleStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ScaleStatusFluent's selector is equal to the given one.
   * @param selector the given selector to compare the actual ScaleStatusFluent's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleStatusFluent's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual ScaleStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ScaleStatusFluent's targetSelector is equal to the given one.
   * @param targetSelector the given targetSelector to compare the actual ScaleStatusFluent's targetSelector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleStatusFluent's targetSelector is not equal to the given one.
   */
  public S hasTargetSelector(String targetSelector) {
    // check that actual ScaleStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTargetSelector = actual.getTargetSelector();
    if (!Objects.areEqual(actualTargetSelector, targetSelector)) {
      failWithMessage(assertjErrorMessage, actual, targetSelector, actualTargetSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
