package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IngressTLSFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressTLSFluentAssert<S extends AbstractIngressTLSFluentAssert<S, A>, A extends IngressTLSFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressTLSFluentAssert}</code> to make assertions on actual IngressTLSFluent.
   * @param actual the IngressTLSFluent we want to make assertions on.
   */
  protected AbstractIngressTLSFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IngressTLSFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IngressTLSFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressTLSFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IngressTLSFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressTLSFluent's hosts contains the given String elements.
   * @param hosts the given elements that should be contained in actual IngressTLSFluent's hosts.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressTLSFluent's hosts does not contain all given String elements.
   */
  public S hasHosts(String... hosts) {
    // check that actual IngressTLSFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (hosts == null) failWithMessage("Expecting hosts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getHosts(), hosts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressTLSFluent's hosts contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param hosts the given elements that should be contained in actual IngressTLSFluent's hosts.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressTLSFluent's hosts does not contain all given String elements.
   */
  public S hasOnlyHosts(String... hosts) {
    // check that actual IngressTLSFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (hosts == null) failWithMessage("Expecting hosts parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getHosts(), hosts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressTLSFluent's hosts does not contain the given String elements.
   *
   * @param hosts the given elements that should not be in actual IngressTLSFluent's hosts.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressTLSFluent's hosts contains any given String elements.
   */
  public S doesNotHaveHosts(String... hosts) {
    // check that actual IngressTLSFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (hosts == null) failWithMessage("Expecting hosts parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getHosts(), hosts);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressTLSFluent has no hosts.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressTLSFluent's hosts is not empty.
   */
  public S hasNoHosts() {
    // check that actual IngressTLSFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have hosts but had :\n  <%s>";
    
    // check
    if (actual.getHosts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getHosts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual IngressTLSFluent's secretName is equal to the given one.
   * @param secretName the given secretName to compare the actual IngressTLSFluent's secretName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressTLSFluent's secretName is not equal to the given one.
   */
  public S hasSecretName(String secretName) {
    // check that actual IngressTLSFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecretName = actual.getSecretName();
    if (!Objects.areEqual(actualSecretName, secretName)) {
      failWithMessage(assertjErrorMessage, actual, secretName, actualSecretName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
