package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IngressSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressSpecFluentAssert<S extends AbstractIngressSpecFluentAssert<S, A>, A extends IngressSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressSpecFluentAssert}</code> to make assertions on actual IngressSpecFluent.
   * @param actual the IngressSpecFluent we want to make assertions on.
   */
  protected AbstractIngressSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IngressSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IngressSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent's backend is equal to the given one.
   * @param backend the given backend to compare the actual IngressSpecFluent's backend to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressSpecFluent's backend is not equal to the given one.
   */
  public S hasBackend(IngressBackend backend) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting backend of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    IngressBackend actualBackend = actual.getBackend();
    if (!Objects.areEqual(actualBackend, backend)) {
      failWithMessage(assertjErrorMessage, actual, backend, actualBackend);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent's rules contains the given IngressRule elements.
   * @param rules the given elements that should be contained in actual IngressSpecFluent's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's rules does not contain all given IngressRule elements.
   */
  public S hasRules(IngressRule... rules) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IngressRule varargs is not null.
    if (rules == null) failWithMessage("Expecting rules parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent's rules contains <b>only<b> the given IngressRule elements and nothing else in whatever order.
   * @param rules the given elements that should be contained in actual IngressSpecFluent's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's rules does not contain all given IngressRule elements.
   */
  public S hasOnlyRules(IngressRule... rules) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IngressRule varargs is not null.
    if (rules == null) failWithMessage("Expecting rules parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent's rules does not contain the given IngressRule elements.
   *
   * @param rules the given elements that should not be in actual IngressSpecFluent's rules.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's rules contains any given IngressRule elements.
   */
  public S doesNotHaveRules(IngressRule... rules) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IngressRule varargs is not null.
    if (rules == null) failWithMessage("Expecting rules parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getRules(), rules);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent has no rules.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's rules is not empty.
   */
  public S hasNoRules() {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have rules but had :\n  <%s>";
    
    // check
    if (actual.getRules().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRules());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual IngressSpecFluent's tls contains the given IngressTLS elements.
   * @param tls the given elements that should be contained in actual IngressSpecFluent's tls.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's tls does not contain all given IngressTLS elements.
   */
  public S hasTls(IngressTLS... tls) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IngressTLS varargs is not null.
    if (tls == null) failWithMessage("Expecting tls parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTls(), tls);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent's tls contains <b>only<b> the given IngressTLS elements and nothing else in whatever order.
   * @param tls the given elements that should be contained in actual IngressSpecFluent's tls.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's tls does not contain all given IngressTLS elements.
   */
  public S hasOnlyTls(IngressTLS... tls) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IngressTLS varargs is not null.
    if (tls == null) failWithMessage("Expecting tls parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getTls(), tls);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent's tls does not contain the given IngressTLS elements.
   *
   * @param tls the given elements that should not be in actual IngressSpecFluent's tls.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's tls contains any given IngressTLS elements.
   */
  public S doesNotHaveTls(IngressTLS... tls) {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given IngressTLS varargs is not null.
    if (tls == null) failWithMessage("Expecting tls parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getTls(), tls);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressSpecFluent has no tls.
   * @return this assertion object.
   * @throws AssertionError if the actual IngressSpecFluent's tls is not empty.
   */
  public S hasNoTls() {
    // check that actual IngressSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tls but had :\n  <%s>";
    
    // check
    if (actual.getTls().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTls());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
