package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentStatusFluentImplAssert<S extends AbstractDeploymentStatusFluentImplAssert<S, A>, A extends DeploymentStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentStatusFluentImplAssert}</code> to make assertions on actual DeploymentStatusFluentImpl.
   * @param actual the DeploymentStatusFluentImpl we want to make assertions on.
   */
  protected AbstractDeploymentStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStatusFluentImpl's availableReplicas is equal to the given one.
   * @param availableReplicas the given availableReplicas to compare the actual DeploymentStatusFluentImpl's availableReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStatusFluentImpl's availableReplicas is not equal to the given one.
   */
  public S hasAvailableReplicas(Integer availableReplicas) {
    // check that actual DeploymentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting availableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualAvailableReplicas = actual.getAvailableReplicas();
    if (!Objects.areEqual(actualAvailableReplicas, availableReplicas)) {
      failWithMessage(assertjErrorMessage, actual, availableReplicas, actualAvailableReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStatusFluentImpl's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual DeploymentStatusFluentImpl's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStatusFluentImpl's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual DeploymentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStatusFluentImpl's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentStatusFluentImpl's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStatusFluentImpl's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStatusFluentImpl's unavailableReplicas is equal to the given one.
   * @param unavailableReplicas the given unavailableReplicas to compare the actual DeploymentStatusFluentImpl's unavailableReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStatusFluentImpl's unavailableReplicas is not equal to the given one.
   */
  public S hasUnavailableReplicas(Integer unavailableReplicas) {
    // check that actual DeploymentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting unavailableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUnavailableReplicas = actual.getUnavailableReplicas();
    if (!Objects.areEqual(actualUnavailableReplicas, unavailableReplicas)) {
      failWithMessage(assertjErrorMessage, actual, unavailableReplicas, actualUnavailableReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStatusFluentImpl's updatedReplicas is equal to the given one.
   * @param updatedReplicas the given updatedReplicas to compare the actual DeploymentStatusFluentImpl's updatedReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStatusFluentImpl's updatedReplicas is not equal to the given one.
   */
  public S hasUpdatedReplicas(Integer updatedReplicas) {
    // check that actual DeploymentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updatedReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUpdatedReplicas = actual.getUpdatedReplicas();
    if (!Objects.areEqual(actualUpdatedReplicas, updatedReplicas)) {
      failWithMessage(assertjErrorMessage, actual, updatedReplicas, actualUpdatedReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
