package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentSpecAssert<S extends AbstractDeploymentSpecAssert<S, A>, A extends DeploymentSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentSpecAssert}</code> to make assertions on actual DeploymentSpec.
   * @param actual the DeploymentSpec we want to make assertions on.
   */
  protected AbstractDeploymentSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentSpec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentSpec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's minReadySeconds is equal to the given one.
   * @param minReadySeconds the given minReadySeconds to compare the actual DeploymentSpec's minReadySeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's minReadySeconds is not equal to the given one.
   */
  public S hasMinReadySeconds(Integer minReadySeconds) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMinReadySeconds = actual.getMinReadySeconds();
    if (!Objects.areEqual(actualMinReadySeconds, minReadySeconds)) {
      failWithMessage(assertjErrorMessage, actual, minReadySeconds, actualMinReadySeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's paused is equal to the given one.
   * @param paused the given paused to compare the actual DeploymentSpec's paused to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's paused is not equal to the given one.
   */
  public S hasPaused(Boolean paused) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting paused of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualPaused = actual.getPaused();
    if (!Objects.areEqual(actualPaused, paused)) {
      failWithMessage(assertjErrorMessage, actual, paused, actualPaused);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentSpec's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's revisionHistoryLimit is equal to the given one.
   * @param revisionHistoryLimit the given revisionHistoryLimit to compare the actual DeploymentSpec's revisionHistoryLimit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's revisionHistoryLimit is not equal to the given one.
   */
  public S hasRevisionHistoryLimit(Integer revisionHistoryLimit) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting revisionHistoryLimit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualRevisionHistoryLimit = actual.getRevisionHistoryLimit();
    if (!Objects.areEqual(actualRevisionHistoryLimit, revisionHistoryLimit)) {
      failWithMessage(assertjErrorMessage, actual, revisionHistoryLimit, actualRevisionHistoryLimit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's rollbackTo is equal to the given one.
   * @param rollbackTo the given rollbackTo to compare the actual DeploymentSpec's rollbackTo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's rollbackTo is not equal to the given one.
   */
  public S hasRollbackTo(RollbackConfig rollbackTo) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rollbackTo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RollbackConfig actualRollbackTo = actual.getRollbackTo();
    if (!Objects.areEqual(actualRollbackTo, rollbackTo)) {
      failWithMessage(assertjErrorMessage, actual, rollbackTo, actualRollbackTo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's selector is equal to the given one.
   * @param selector the given selector to compare the actual DeploymentSpec's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's selector is not equal to the given one.
   */
  public S hasSelector(LabelSelector selector) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LabelSelector actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual DeploymentSpec's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's strategy is not equal to the given one.
   */
  public S hasStrategy(DeploymentStrategy strategy) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentSpec's template is equal to the given one.
   * @param template the given template to compare the actual DeploymentSpec's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentSpec's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual DeploymentSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
