package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServiceAccount} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceAccountAssert<S extends AbstractServiceAccountAssert<S, A>, A extends ServiceAccount> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceAccountAssert}</code> to make assertions on actual ServiceAccount.
   * @param actual the ServiceAccount we want to make assertions on.
   */
  protected AbstractServiceAccountAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServiceAccount's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServiceAccount's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ServiceAccount's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's imagePullSecrets contains the given LocalObjectReference elements.
   * @param imagePullSecrets the given elements that should be contained in actual ServiceAccount's imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's imagePullSecrets does not contain all given LocalObjectReference elements.
   */
  public S hasImagePullSecrets(LocalObjectReference... imagePullSecrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given LocalObjectReference varargs is not null.
    if (imagePullSecrets == null) failWithMessage("Expecting imagePullSecrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImagePullSecrets(), imagePullSecrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's imagePullSecrets contains <b>only<b> the given LocalObjectReference elements and nothing else in whatever order.
   * @param imagePullSecrets the given elements that should be contained in actual ServiceAccount's imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's imagePullSecrets does not contain all given LocalObjectReference elements.
   */
  public S hasOnlyImagePullSecrets(LocalObjectReference... imagePullSecrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given LocalObjectReference varargs is not null.
    if (imagePullSecrets == null) failWithMessage("Expecting imagePullSecrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getImagePullSecrets(), imagePullSecrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's imagePullSecrets does not contain the given LocalObjectReference elements.
   *
   * @param imagePullSecrets the given elements that should not be in actual ServiceAccount's imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's imagePullSecrets contains any given LocalObjectReference elements.
   */
  public S doesNotHaveImagePullSecrets(LocalObjectReference... imagePullSecrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given LocalObjectReference varargs is not null.
    if (imagePullSecrets == null) failWithMessage("Expecting imagePullSecrets parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getImagePullSecrets(), imagePullSecrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount has no imagePullSecrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's imagePullSecrets is not empty.
   */
  public S hasNoImagePullSecrets() {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have imagePullSecrets but had :\n  <%s>";
    
    // check
    if (actual.getImagePullSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImagePullSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ServiceAccount's kind is equal to the given one.
   * @param kind the given kind to compare the actual ServiceAccount's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ServiceAccount's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceAccount's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's secrets contains the given ObjectReference elements.
   * @param secrets the given elements that should be contained in actual ServiceAccount's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's secrets does not contain all given ObjectReference elements.
   */
  public S hasSecrets(ObjectReference... secrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given ObjectReference varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's secrets contains <b>only<b> the given ObjectReference elements and nothing else in whatever order.
   * @param secrets the given elements that should be contained in actual ServiceAccount's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's secrets does not contain all given ObjectReference elements.
   */
  public S hasOnlySecrets(ObjectReference... secrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given ObjectReference varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount's secrets does not contain the given ObjectReference elements.
   *
   * @param secrets the given elements that should not be in actual ServiceAccount's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's secrets contains any given ObjectReference elements.
   */
  public S doesNotHaveSecrets(ObjectReference... secrets) {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // check that given ObjectReference varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceAccount has no secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceAccount's secrets is not empty.
   */
  public S hasNoSecrets() {
    // check that actual ServiceAccount we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have secrets but had :\n  <%s>";
    
    // check
    if (actual.getSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
