package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodTemplate} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodTemplateAssert<S extends AbstractPodTemplateAssert<S, A>, A extends PodTemplate> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodTemplateAssert}</code> to make assertions on actual PodTemplate.
   * @param actual the PodTemplate we want to make assertions on.
   */
  protected AbstractPodTemplateAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodTemplate's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodTemplate's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplate's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual PodTemplate's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplate's kind is equal to the given one.
   * @param kind the given kind to compare the actual PodTemplate's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplate's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual PodTemplate's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodTemplate's template is equal to the given one.
   * @param template the given template to compare the actual PodTemplate's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodTemplate's template is not equal to the given one.
   */
  public S hasTemplate(PodTemplateSpec template) {
    // check that actual PodTemplate we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
