package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PersistentVolumeSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeSpecFluentAssert<S extends AbstractPersistentVolumeSpecFluentAssert<S, A>, A extends PersistentVolumeSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeSpecFluentAssert}</code> to make assertions on actual PersistentVolumeSpecFluent.
   * @param actual the PersistentVolumeSpecFluent we want to make assertions on.
   */
  protected AbstractPersistentVolumeSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's accessModes contains the given String elements.
   * @param accessModes the given elements that should be contained in actual PersistentVolumeSpecFluent's accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeSpecFluent's accessModes does not contain all given String elements.
   */
  public S hasAccessModes(String... accessModes) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (accessModes == null) failWithMessage("Expecting accessModes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAccessModes(), accessModes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's accessModes contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param accessModes the given elements that should be contained in actual PersistentVolumeSpecFluent's accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeSpecFluent's accessModes does not contain all given String elements.
   */
  public S hasOnlyAccessModes(String... accessModes) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (accessModes == null) failWithMessage("Expecting accessModes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getAccessModes(), accessModes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's accessModes does not contain the given String elements.
   *
   * @param accessModes the given elements that should not be in actual PersistentVolumeSpecFluent's accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeSpecFluent's accessModes contains any given String elements.
   */
  public S doesNotHaveAccessModes(String... accessModes) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (accessModes == null) failWithMessage("Expecting accessModes parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getAccessModes(), accessModes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent has no accessModes.
   * @return this assertion object.
   * @throws AssertionError if the actual PersistentVolumeSpecFluent's accessModes is not empty.
   */
  public S hasNoAccessModes() {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have accessModes but had :\n  <%s>";
    
    // check
    if (actual.getAccessModes().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAccessModes());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PersistentVolumeSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's awsElasticBlockStore is equal to the given one.
   * @param awsElasticBlockStore the given awsElasticBlockStore to compare the actual PersistentVolumeSpecFluent's awsElasticBlockStore to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's awsElasticBlockStore is not equal to the given one.
   */
  public S hasAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting awsElasticBlockStore of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    AWSElasticBlockStoreVolumeSource actualAwsElasticBlockStore = actual.getAwsElasticBlockStore();
    if (!Objects.areEqual(actualAwsElasticBlockStore, awsElasticBlockStore)) {
      failWithMessage(assertjErrorMessage, actual, awsElasticBlockStore, actualAwsElasticBlockStore);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's azureFile is equal to the given one.
   * @param azureFile the given azureFile to compare the actual PersistentVolumeSpecFluent's azureFile to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's azureFile is not equal to the given one.
   */
  public S hasAzureFile(AzureFileVolumeSource azureFile) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting azureFile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    AzureFileVolumeSource actualAzureFile = actual.getAzureFile();
    if (!Objects.areEqual(actualAzureFile, azureFile)) {
      failWithMessage(assertjErrorMessage, actual, azureFile, actualAzureFile);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's capacity is equal to the given one.
   * @param capacity the given capacity to compare the actual PersistentVolumeSpecFluent's capacity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's capacity is not equal to the given one.
   */
  public S hasCapacity(java.util.Map capacity) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting capacity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualCapacity = actual.getCapacity();
    if (!Objects.areEqual(actualCapacity, capacity)) {
      failWithMessage(assertjErrorMessage, actual, capacity, actualCapacity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's cephfs is equal to the given one.
   * @param cephfs the given cephfs to compare the actual PersistentVolumeSpecFluent's cephfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's cephfs is not equal to the given one.
   */
  public S hasCephfs(CephFSVolumeSource cephfs) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cephfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CephFSVolumeSource actualCephfs = actual.getCephfs();
    if (!Objects.areEqual(actualCephfs, cephfs)) {
      failWithMessage(assertjErrorMessage, actual, cephfs, actualCephfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's cinder is equal to the given one.
   * @param cinder the given cinder to compare the actual PersistentVolumeSpecFluent's cinder to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's cinder is not equal to the given one.
   */
  public S hasCinder(CinderVolumeSource cinder) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cinder of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CinderVolumeSource actualCinder = actual.getCinder();
    if (!Objects.areEqual(actualCinder, cinder)) {
      failWithMessage(assertjErrorMessage, actual, cinder, actualCinder);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's claimRef is equal to the given one.
   * @param claimRef the given claimRef to compare the actual PersistentVolumeSpecFluent's claimRef to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's claimRef is not equal to the given one.
   */
  public S hasClaimRef(ObjectReference claimRef) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting claimRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectReference actualClaimRef = actual.getClaimRef();
    if (!Objects.areEqual(actualClaimRef, claimRef)) {
      failWithMessage(assertjErrorMessage, actual, claimRef, actualClaimRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's fc is equal to the given one.
   * @param fc the given fc to compare the actual PersistentVolumeSpecFluent's fc to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's fc is not equal to the given one.
   */
  public S hasFc(FCVolumeSource fc) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FCVolumeSource actualFc = actual.getFc();
    if (!Objects.areEqual(actualFc, fc)) {
      failWithMessage(assertjErrorMessage, actual, fc, actualFc);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's flexVolume is equal to the given one.
   * @param flexVolume the given flexVolume to compare the actual PersistentVolumeSpecFluent's flexVolume to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's flexVolume is not equal to the given one.
   */
  public S hasFlexVolume(FlexVolumeSource flexVolume) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting flexVolume of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FlexVolumeSource actualFlexVolume = actual.getFlexVolume();
    if (!Objects.areEqual(actualFlexVolume, flexVolume)) {
      failWithMessage(assertjErrorMessage, actual, flexVolume, actualFlexVolume);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's flocker is equal to the given one.
   * @param flocker the given flocker to compare the actual PersistentVolumeSpecFluent's flocker to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's flocker is not equal to the given one.
   */
  public S hasFlocker(FlockerVolumeSource flocker) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting flocker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FlockerVolumeSource actualFlocker = actual.getFlocker();
    if (!Objects.areEqual(actualFlocker, flocker)) {
      failWithMessage(assertjErrorMessage, actual, flocker, actualFlocker);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's gcePersistentDisk is equal to the given one.
   * @param gcePersistentDisk the given gcePersistentDisk to compare the actual PersistentVolumeSpecFluent's gcePersistentDisk to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's gcePersistentDisk is not equal to the given one.
   */
  public S hasGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting gcePersistentDisk of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GCEPersistentDiskVolumeSource actualGcePersistentDisk = actual.getGcePersistentDisk();
    if (!Objects.areEqual(actualGcePersistentDisk, gcePersistentDisk)) {
      failWithMessage(assertjErrorMessage, actual, gcePersistentDisk, actualGcePersistentDisk);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's glusterfs is equal to the given one.
   * @param glusterfs the given glusterfs to compare the actual PersistentVolumeSpecFluent's glusterfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's glusterfs is not equal to the given one.
   */
  public S hasGlusterfs(GlusterfsVolumeSource glusterfs) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting glusterfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GlusterfsVolumeSource actualGlusterfs = actual.getGlusterfs();
    if (!Objects.areEqual(actualGlusterfs, glusterfs)) {
      failWithMessage(assertjErrorMessage, actual, glusterfs, actualGlusterfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's hostPath is equal to the given one.
   * @param hostPath the given hostPath to compare the actual PersistentVolumeSpecFluent's hostPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's hostPath is not equal to the given one.
   */
  public S hasHostPath(HostPathVolumeSource hostPath) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting hostPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HostPathVolumeSource actualHostPath = actual.getHostPath();
    if (!Objects.areEqual(actualHostPath, hostPath)) {
      failWithMessage(assertjErrorMessage, actual, hostPath, actualHostPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's iscsi is equal to the given one.
   * @param iscsi the given iscsi to compare the actual PersistentVolumeSpecFluent's iscsi to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's iscsi is not equal to the given one.
   */
  public S hasIscsi(ISCSIVolumeSource iscsi) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting iscsi of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ISCSIVolumeSource actualIscsi = actual.getIscsi();
    if (!Objects.areEqual(actualIscsi, iscsi)) {
      failWithMessage(assertjErrorMessage, actual, iscsi, actualIscsi);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's nfs is equal to the given one.
   * @param nfs the given nfs to compare the actual PersistentVolumeSpecFluent's nfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's nfs is not equal to the given one.
   */
  public S hasNfs(NFSVolumeSource nfs) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting nfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NFSVolumeSource actualNfs = actual.getNfs();
    if (!Objects.areEqual(actualNfs, nfs)) {
      failWithMessage(assertjErrorMessage, actual, nfs, actualNfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's persistentVolumeReclaimPolicy is equal to the given one.
   * @param persistentVolumeReclaimPolicy the given persistentVolumeReclaimPolicy to compare the actual PersistentVolumeSpecFluent's persistentVolumeReclaimPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's persistentVolumeReclaimPolicy is not equal to the given one.
   */
  public S hasPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting persistentVolumeReclaimPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPersistentVolumeReclaimPolicy = actual.getPersistentVolumeReclaimPolicy();
    if (!Objects.areEqual(actualPersistentVolumeReclaimPolicy, persistentVolumeReclaimPolicy)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeReclaimPolicy, actualPersistentVolumeReclaimPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PersistentVolumeSpecFluent's rbd is equal to the given one.
   * @param rbd the given rbd to compare the actual PersistentVolumeSpecFluent's rbd to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PersistentVolumeSpecFluent's rbd is not equal to the given one.
   */
  public S hasRbd(RBDVolumeSource rbd) {
    // check that actual PersistentVolumeSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rbd of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RBDVolumeSource actualRbd = actual.getRbd();
    if (!Objects.areEqual(actualRbd, rbd)) {
      failWithMessage(assertjErrorMessage, actual, rbd, actualRbd);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
