package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KeyToPath} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKeyToPathAssert<S extends AbstractKeyToPathAssert<S, A>, A extends KeyToPath> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKeyToPathAssert}</code> to make assertions on actual KeyToPath.
   * @param actual the KeyToPath we want to make assertions on.
   */
  protected AbstractKeyToPathAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KeyToPath's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KeyToPath's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPath's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KeyToPath's key is equal to the given one.
   * @param key the given key to compare the actual KeyToPath's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPath's key is not equal to the given one.
   */
  public S hasKey(String key) {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKey = actual.getKey();
    if (!Objects.areEqual(actualKey, key)) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KeyToPath's path is equal to the given one.
   * @param path the given path to compare the actual KeyToPath's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KeyToPath's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual KeyToPath we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
