package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HTTPHeaderFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPHeaderFluentAssert<S extends AbstractHTTPHeaderFluentAssert<S, A>, A extends HTTPHeaderFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPHeaderFluentAssert}</code> to make assertions on actual HTTPHeaderFluent.
   * @param actual the HTTPHeaderFluent we want to make assertions on.
   */
  protected AbstractHTTPHeaderFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HTTPHeaderFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HTTPHeaderFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPHeaderFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HTTPHeaderFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPHeaderFluent's name is equal to the given one.
   * @param name the given name to compare the actual HTTPHeaderFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPHeaderFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual HTTPHeaderFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPHeaderFluent's value is equal to the given one.
   * @param value the given value to compare the actual HTTPHeaderFluent's value to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPHeaderFluent's value is not equal to the given one.
   */
  public S hasValue(String value) {
    // check that actual HTTPHeaderFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualValue = actual.getValue();
    if (!Objects.areEqual(actualValue, value)) {
      failWithMessage(assertjErrorMessage, actual, value, actualValue);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
