package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GCEPersistentDiskVolumeSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGCEPersistentDiskVolumeSourceFluentImplAssert<S extends AbstractGCEPersistentDiskVolumeSourceFluentImplAssert<S, A>, A extends GCEPersistentDiskVolumeSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGCEPersistentDiskVolumeSourceFluentImplAssert}</code> to make assertions on actual GCEPersistentDiskVolumeSourceFluentImpl.
   * @param actual the GCEPersistentDiskVolumeSourceFluentImpl we want to make assertions on.
   */
  protected AbstractGCEPersistentDiskVolumeSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GCEPersistentDiskVolumeSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GCEPersistentDiskVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSourceFluentImpl's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual GCEPersistentDiskVolumeSourceFluentImpl's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSourceFluentImpl's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual GCEPersistentDiskVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSourceFluentImpl's partition is equal to the given one.
   * @param partition the given partition to compare the actual GCEPersistentDiskVolumeSourceFluentImpl's partition to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSourceFluentImpl's partition is not equal to the given one.
   */
  public S hasPartition(Integer partition) {
    // check that actual GCEPersistentDiskVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting partition of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualPartition = actual.getPartition();
    if (!Objects.areEqual(actualPartition, partition)) {
      failWithMessage(assertjErrorMessage, actual, partition, actualPartition);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GCEPersistentDiskVolumeSourceFluentImpl's pdName is equal to the given one.
   * @param pdName the given pdName to compare the actual GCEPersistentDiskVolumeSourceFluentImpl's pdName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GCEPersistentDiskVolumeSourceFluentImpl's pdName is not equal to the given one.
   */
  public S hasPdName(String pdName) {
    // check that actual GCEPersistentDiskVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pdName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPdName = actual.getPdName();
    if (!Objects.areEqual(actualPdName, pdName)) {
      failWithMessage(assertjErrorMessage, actual, pdName, actualPdName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
