package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ConfigMapVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigMapVolumeSourceAssert<S extends AbstractConfigMapVolumeSourceAssert<S, A>, A extends ConfigMapVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigMapVolumeSourceAssert}</code> to make assertions on actual ConfigMapVolumeSource.
   * @param actual the ConfigMapVolumeSource we want to make assertions on.
   */
  protected AbstractConfigMapVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ConfigMapVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ConfigMapVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ConfigMapVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapVolumeSource's items contains the given KeyToPath elements.
   * @param items the given elements that should be contained in actual ConfigMapVolumeSource's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapVolumeSource's items does not contain all given KeyToPath elements.
   */
  public S hasItems(KeyToPath... items) {
    // check that actual ConfigMapVolumeSource we want to make assertions on is not null.
    isNotNull();

    // check that given KeyToPath varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapVolumeSource's items contains <b>only<b> the given KeyToPath elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual ConfigMapVolumeSource's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapVolumeSource's items does not contain all given KeyToPath elements.
   */
  public S hasOnlyItems(KeyToPath... items) {
    // check that actual ConfigMapVolumeSource we want to make assertions on is not null.
    isNotNull();

    // check that given KeyToPath varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapVolumeSource's items does not contain the given KeyToPath elements.
   *
   * @param items the given elements that should not be in actual ConfigMapVolumeSource's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapVolumeSource's items contains any given KeyToPath elements.
   */
  public S doesNotHaveItems(KeyToPath... items) {
    // check that actual ConfigMapVolumeSource we want to make assertions on is not null.
    isNotNull();

    // check that given KeyToPath varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapVolumeSource has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapVolumeSource's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ConfigMapVolumeSource we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ConfigMapVolumeSource's name is equal to the given one.
   * @param name the given name to compare the actual ConfigMapVolumeSource's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapVolumeSource's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ConfigMapVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
