package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ConfigMapKeySelectorFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigMapKeySelectorFluentImplAssert<S extends AbstractConfigMapKeySelectorFluentImplAssert<S, A>, A extends ConfigMapKeySelectorFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigMapKeySelectorFluentImplAssert}</code> to make assertions on actual ConfigMapKeySelectorFluentImpl.
   * @param actual the ConfigMapKeySelectorFluentImpl we want to make assertions on.
   */
  protected AbstractConfigMapKeySelectorFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ConfigMapKeySelectorFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ConfigMapKeySelectorFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapKeySelectorFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ConfigMapKeySelectorFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapKeySelectorFluentImpl's key is equal to the given one.
   * @param key the given key to compare the actual ConfigMapKeySelectorFluentImpl's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapKeySelectorFluentImpl's key is not equal to the given one.
   */
  public S hasKey(String key) {
    // check that actual ConfigMapKeySelectorFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKey = actual.getKey();
    if (!Objects.areEqual(actualKey, key)) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapKeySelectorFluentImpl's name is equal to the given one.
   * @param name the given name to compare the actual ConfigMapKeySelectorFluentImpl's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapKeySelectorFluentImpl's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ConfigMapKeySelectorFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
