package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ComponentStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractComponentStatusFluentImplAssert<S extends AbstractComponentStatusFluentImplAssert<S, A>, A extends ComponentStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractComponentStatusFluentImplAssert}</code> to make assertions on actual ComponentStatusFluentImpl.
   * @param actual the ComponentStatusFluentImpl we want to make assertions on.
   */
  protected AbstractComponentStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ComponentStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ComponentStatusFluentImpl's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentStatusFluentImpl's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(String apiVersion) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl's conditions contains the given ComponentCondition elements.
   * @param conditions the given elements that should be contained in actual ComponentStatusFluentImpl's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual ComponentStatusFluentImpl's conditions does not contain all given ComponentCondition elements.
   */
  public S hasConditions(ComponentCondition... conditions) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ComponentCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl's conditions contains <b>only<b> the given ComponentCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual ComponentStatusFluentImpl's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual ComponentStatusFluentImpl's conditions does not contain all given ComponentCondition elements.
   */
  public S hasOnlyConditions(ComponentCondition... conditions) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ComponentCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl's conditions does not contain the given ComponentCondition elements.
   *
   * @param conditions the given elements that should not be in actual ComponentStatusFluentImpl's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual ComponentStatusFluentImpl's conditions contains any given ComponentCondition elements.
   */
  public S doesNotHaveConditions(ComponentCondition... conditions) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ComponentCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual ComponentStatusFluentImpl's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ComponentStatusFluentImpl's kind is equal to the given one.
   * @param kind the given kind to compare the actual ComponentStatusFluentImpl's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentStatusFluentImpl's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ComponentStatusFluentImpl's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ComponentStatusFluentImpl's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ComponentStatusFluentImpl's metadata is not equal to the given one.
   */
  public S hasMetadata(ObjectMeta metadata) {
    // check that actual ComponentStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
