package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link AzureFileVolumeSourceFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAzureFileVolumeSourceFluentImplAssert<S extends AbstractAzureFileVolumeSourceFluentImplAssert<S, A>, A extends AzureFileVolumeSourceFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAzureFileVolumeSourceFluentImplAssert}</code> to make assertions on actual AzureFileVolumeSourceFluentImpl.
   * @param actual the AzureFileVolumeSourceFluentImpl we want to make assertions on.
   */
  protected AbstractAzureFileVolumeSourceFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual AzureFileVolumeSourceFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual AzureFileVolumeSourceFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSourceFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual AzureFileVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AzureFileVolumeSourceFluentImpl's secretName is equal to the given one.
   * @param secretName the given secretName to compare the actual AzureFileVolumeSourceFluentImpl's secretName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSourceFluentImpl's secretName is not equal to the given one.
   */
  public S hasSecretName(String secretName) {
    // check that actual AzureFileVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecretName = actual.getSecretName();
    if (!Objects.areEqual(actualSecretName, secretName)) {
      failWithMessage(assertjErrorMessage, actual, secretName, actualSecretName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AzureFileVolumeSourceFluentImpl's shareName is equal to the given one.
   * @param shareName the given shareName to compare the actual AzureFileVolumeSourceFluentImpl's shareName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSourceFluentImpl's shareName is not equal to the given one.
   */
  public S hasShareName(String shareName) {
    // check that actual AzureFileVolumeSourceFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting shareName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualShareName = actual.getShareName();
    if (!Objects.areEqual(actualShareName, shareName)) {
      failWithMessage(assertjErrorMessage, actual, shareName, actualShareName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
