package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link AzureFileVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractAzureFileVolumeSourceAssert<S extends AbstractAzureFileVolumeSourceAssert<S, A>, A extends AzureFileVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractAzureFileVolumeSourceAssert}</code> to make assertions on actual AzureFileVolumeSource.
   * @param actual the AzureFileVolumeSource we want to make assertions on.
   */
  protected AbstractAzureFileVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual AzureFileVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual AzureFileVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AzureFileVolumeSource's readOnly is equal to the given one.
   * @param readOnly the given readOnly to compare the actual AzureFileVolumeSource's readOnly to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSource's readOnly is not equal to the given one.
   */
  public S hasReadOnly(Boolean readOnly) {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readOnly of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReadOnly = actual.getReadOnly();
    if (!Objects.areEqual(actualReadOnly, readOnly)) {
      failWithMessage(assertjErrorMessage, actual, readOnly, actualReadOnly);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AzureFileVolumeSource's secretName is equal to the given one.
   * @param secretName the given secretName to compare the actual AzureFileVolumeSource's secretName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSource's secretName is not equal to the given one.
   */
  public S hasSecretName(String secretName) {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecretName = actual.getSecretName();
    if (!Objects.areEqual(actualSecretName, secretName)) {
      failWithMessage(assertjErrorMessage, actual, secretName, actualSecretName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual AzureFileVolumeSource's shareName is equal to the given one.
   * @param shareName the given shareName to compare the actual AzureFileVolumeSource's shareName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual AzureFileVolumeSource's shareName is not equal to the given one.
   */
  public S hasShareName(String shareName) {
    // check that actual AzureFileVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting shareName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualShareName = actual.getShareName();
    if (!Objects.areEqual(actualShareName, shareName)) {
      failWithMessage(assertjErrorMessage, actual, shareName, actualShareName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
